/*
 * Decompiled with CFR 0.152.
 */
package io.github.foundationgames.automobility.block.entity;

import io.github.foundationgames.automobility.automobile.AutomobileEngine;
import io.github.foundationgames.automobility.automobile.AutomobileFrame;
import io.github.foundationgames.automobility.automobile.AutomobileStats;
import io.github.foundationgames.automobility.automobile.AutomobileWheel;
import io.github.foundationgames.automobility.automobile.attachment.front.FrontAttachment;
import io.github.foundationgames.automobility.automobile.attachment.rear.RearAttachment;
import io.github.foundationgames.automobility.automobile.render.RenderableAutomobile;
import io.github.foundationgames.automobility.block.AutomobileAssemblerBlock;
import io.github.foundationgames.automobility.block.AutomobilityBlocks;
import io.github.foundationgames.automobility.entity.AutomobileEntity;
import io.github.foundationgames.automobility.item.AutomobileEngineItem;
import io.github.foundationgames.automobility.item.AutomobileFrameItem;
import io.github.foundationgames.automobility.item.AutomobileWheelItem;
import io.github.foundationgames.automobility.item.AutomobilityItems;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.network.protocol.game.ClientboundLevelParticlesPacket;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3f;

public class AutomobileAssemblerBlockEntity
extends BlockEntity
implements RenderableAutomobile {
    protected Holder<AutomobileFrame> frame = Holder.direct((Object)AutomobileFrame.EMPTY);
    protected Holder<AutomobileEngine> engine = Holder.direct((Object)AutomobileEngine.EMPTY);
    protected Holder<AutomobileWheel> wheel = Holder.direct((Object)AutomobileWheel.EMPTY);
    protected int wheelCount = 0;
    public final List<Component> label = new ArrayList<Component>();
    protected final AutomobileStats stats = new AutomobileStats();

    public AutomobileAssemblerBlockEntity(BlockPos pos, BlockState state) {
        super(AutomobilityBlocks.AUTOMOBILE_ASSEMBLER_ENTITY.require(), pos, state);
    }

    @Override
    public AutomobileFrame getFrame() {
        return (AutomobileFrame)this.frame.value();
    }

    @Override
    public AutomobileWheel getWheels() {
        return (AutomobileWheel)this.wheel.value();
    }

    @Override
    public AutomobileEngine getEngine() {
        return (AutomobileEngine)this.engine.value();
    }

    @Override
    @Nullable
    public RearAttachment getRearAttachment() {
        return null;
    }

    @Override
    @Nullable
    public FrontAttachment getFrontAttachment() {
        return null;
    }

    private void partChanged() {
        this.sync();
        this.setChanged();
        this.level.gameEvent((Holder)GameEvent.BLOCK_CHANGE, this.getBlockPos(), new GameEvent.Context(null, this.getBlockState()));
    }

    protected ItemInteractionResult handleItemInteract(Player player, ItemStack stack) {
        Item item;
        if (stack.is(AutomobilityItems.CROWBAR.require())) {
            if (!this.level.isClientSide()) {
                this.dropParts();
                this.partChanged();
                return ItemInteractionResult.SUCCESS;
            }
            return ItemInteractionResult.FAIL;
        }
        if (((AutomobileFrame)this.frame.value()).isEmpty() && (item = stack.getItem()) instanceof AutomobileFrameItem) {
            AutomobileFrameItem frameItem = (AutomobileFrameItem)item;
            if (!this.level.isClientSide()) {
                this.frame = frameItem.lookupComponent(stack, (HolderLookup.Provider)this.getLevel().registryAccess());
                if (!player.isCreative()) {
                    stack.shrink(1);
                }
                this.partChanged();
                return ItemInteractionResult.SUCCESS;
            }
            return ItemInteractionResult.FAIL;
        }
        if (!((AutomobileFrame)this.frame.value()).isEmpty()) {
            if (((AutomobileEngine)this.engine.value()).isEmpty() && (item = stack.getItem()) instanceof AutomobileEngineItem) {
                AutomobileEngineItem engineItem = (AutomobileEngineItem)item;
                if (!this.level.isClientSide()) {
                    this.engine = engineItem.lookupComponent(stack, (HolderLookup.Provider)this.getLevel().registryAccess());
                    if (!player.isCreative()) {
                        stack.shrink(1);
                    }
                    this.partChanged();
                    return ItemInteractionResult.SUCCESS;
                }
                return ItemInteractionResult.FAIL;
            }
            item = stack.getItem();
            if (item instanceof AutomobileWheelItem) {
                AutomobileWheelItem wheelItem = (AutomobileWheelItem)item;
                if (!this.level.isClientSide()) {
                    Holder wheelType = wheelItem.lookupComponent(stack, (HolderLookup.Provider)this.getLevel().registryAccess());
                    if (((AutomobileWheel)this.wheel.value()).isEmpty()) {
                        this.wheel = wheelType;
                        this.wheelCount = 0;
                    }
                    if (this.wheel == wheelType && this.wheelCount < ((AutomobileFrame)this.frame.value()).model().wheelBase().wheelCount()) {
                        ++this.wheelCount;
                        if (!player.isCreative()) {
                            stack.shrink(1);
                        }
                        this.partChanged();
                        return ItemInteractionResult.SUCCESS;
                    }
                } else {
                    return ItemInteractionResult.FAIL;
                }
            }
        }
        if (!this.level.isClientSide() && stack.is((Item)AutomobilityItems.FRONT_ATTACHMENT.require()) || stack.is((Item)AutomobilityItems.REAR_ATTACHMENT.require())) {
            player.displayClientMessage(AutomobileAssemblerBlock.INCOMPLETE_AUTOMOBILE_DIALOG, true);
        }
        return ItemInteractionResult.FAIL;
    }

    public ItemInteractionResult interact(Player player, ItemStack stack, InteractionHand hand) {
        ItemInteractionResult result = this.handleItemInteract(player, stack);
        if (!this.level.isClientSide() && result == ItemInteractionResult.SUCCESS) {
            if (!this.isComplete()) {
                this.level.playSound(null, this.worldPosition, SoundEvents.COPPER_PLACE, SoundSource.BLOCKS, 0.7f, 0.6f + this.level.random.nextFloat() * 0.15f);
            }
            this.tryConstructAutomobile();
            return ItemInteractionResult.SUCCESS;
        }
        return result;
    }

    protected Vec3 centerPos() {
        return new Vec3((double)this.worldPosition.getX() + 0.5, (double)this.worldPosition.getY() + 0.75, (double)this.worldPosition.getZ() + 0.5);
    }

    public boolean isComplete() {
        return !((AutomobileFrame)this.frame.value()).isEmpty() && !((AutomobileEngine)this.engine.value()).isEmpty() && !((AutomobileWheel)this.wheel.value()).isEmpty() && this.wheelCount >= ((AutomobileFrame)this.frame.value()).model().wheelBase().wheelCount();
    }

    public void tryConstructAutomobile() {
        if (this.isComplete()) {
            Vec3 pos = this.centerPos();
            AutomobileEntity auto = new AutomobileEntity(this.level);
            auto.moveTo(pos.x, pos.y, pos.z, this.getAutomobileYaw(0.0f), 0.0f);
            auto.setComponents(this.frame, this.wheel, this.engine);
            this.level.addFreshEntity((Entity)auto);
            this.level.players().forEach(p -> {
                if (p instanceof ServerPlayer) {
                    ServerPlayer player = (ServerPlayer)p;
                    if (p.blockPosition().distSqr((Vec3i)this.worldPosition) < 80000.0) {
                        player.connection.send((Packet)new ClientboundLevelParticlesPacket((ParticleOptions)ParticleTypes.EXPLOSION, false, pos.x, pos.y + 0.47, pos.z, 0.0f, 0.0f, 0.0f, 0.0f, 1));
                    }
                }
            });
            this.level.playSound(null, this.worldPosition, SoundEvents.ANVIL_PLACE, SoundSource.BLOCKS, 0.23f, 0.5f);
            this.clear();
        }
    }

    public void dropParts() {
        Vec3 pos = this.centerPos();
        this.frame.unwrapKey().ifPresent(key -> this.level.addFreshEntity((Entity)new ItemEntity(this.level, pos.x, pos.y, pos.z, AutomobilityItems.AUTOMOBILE_FRAME.require().createStack(key))));
        this.engine.unwrapKey().ifPresent(key -> this.level.addFreshEntity((Entity)new ItemEntity(this.level, pos.x, pos.y, pos.z, AutomobilityItems.AUTOMOBILE_ENGINE.require().createStack(key))));
        this.wheel.unwrapKey().ifPresent(key -> {
            ItemStack wheelStack = AutomobilityItems.AUTOMOBILE_WHEEL.require().createStack(key);
            wheelStack.setCount(this.getFrame().model().wheelBase().wheelCount());
            this.level.addFreshEntity((Entity)new ItemEntity(this.level, pos.x, pos.y, pos.z, wheelStack));
        });
        this.clear();
    }

    public void clear() {
        this.frame = Holder.direct((Object)AutomobileFrame.EMPTY);
        this.wheel = Holder.direct((Object)AutomobileWheel.EMPTY);
        this.engine = Holder.direct((Object)AutomobileEngine.EMPTY);
        this.wheelCount = 0;
    }

    private boolean hasAllParts() {
        return !((AutomobileFrame)this.frame.value()).isEmpty() && !((AutomobileWheel)this.wheel.value()).isEmpty() && !((AutomobileEngine)this.engine.value()).isEmpty();
    }

    private void onComponentsUpdated() {
        if (this.level == null || this.level.isClientSide()) {
            this.label.clear();
            if (this.hasAllParts()) {
                this.stats.from((AutomobileFrame)this.frame.value(), (AutomobileWheel)this.wheel.value(), (AutomobileEngine)this.engine.value());
                this.stats.appendTexts(this.label::add, this.stats);
            }
        }
    }

    private void sync() {
        Level level = this.level;
        if (level instanceof ServerLevel) {
            ServerLevel sWorld = (ServerLevel)level;
            sWorld.getChunkSource().blockChanged(this.worldPosition);
        }
    }

    protected void loadAdditional(CompoundTag nbt, HolderLookup.Provider registries) {
        super.loadAdditional(nbt, registries);
        this.frame = registries.lookupOrThrow(AutomobileFrame.REGISTRY).get(ResourceKey.create(AutomobileFrame.REGISTRY, (ResourceLocation)ResourceLocation.tryParse((String)nbt.getString("frame")))).map(r -> r).orElseGet(() -> Holder.direct((Object)AutomobileFrame.EMPTY));
        this.engine = registries.lookupOrThrow(AutomobileEngine.REGISTRY).get(ResourceKey.create(AutomobileEngine.REGISTRY, (ResourceLocation)ResourceLocation.tryParse((String)nbt.getString("engine")))).map(r -> r).orElseGet(() -> Holder.direct((Object)AutomobileEngine.EMPTY));
        CompoundTag wheelNbt = nbt.getCompound("wheels");
        this.wheel = registries.lookupOrThrow(AutomobileWheel.REGISTRY).get(ResourceKey.create(AutomobileWheel.REGISTRY, (ResourceLocation)ResourceLocation.tryParse((String)wheelNbt.getString("type")))).map(r -> r).orElseGet(() -> Holder.direct((Object)AutomobileWheel.EMPTY));
        this.wheelCount = wheelNbt.getInt("count");
        this.onComponentsUpdated();
    }

    protected void saveAdditional(CompoundTag nbt, HolderLookup.Provider registries) {
        super.saveAdditional(nbt, registries);
        this.frame.unwrapKey().ifPresent(k -> nbt.putString("frame", k.location().toString()));
        this.engine.unwrapKey().ifPresent(k -> nbt.putString("engine", k.location().toString()));
        CompoundTag wheelNbt = new CompoundTag();
        this.wheel.unwrapKey().ifPresent(k -> wheelNbt.putString("type", k.location().toString()));
        wheelNbt.putInt("count", this.wheelCount);
        nbt.put("wheels", (Tag)wheelNbt);
    }

    @Nullable
    public Packet<ClientGamePacketListener> getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    public CompoundTag getUpdateTag(HolderLookup.Provider registries) {
        CompoundTag nbt = new CompoundTag();
        this.saveAdditional(nbt, registries);
        return nbt;
    }

    protected boolean powered() {
        BlockState state = this.level.getBlockState(this.worldPosition);
        return state.hasProperty((Property)AutomobileAssemblerBlock.POWERED) && (Boolean)state.getValue((Property)AutomobileAssemblerBlock.POWERED) != false;
    }

    @Override
    public float getAutomobileYaw(float tickDelta) {
        BlockState state = this.level.getBlockState(this.worldPosition);
        return state.hasProperty((Property)AutomobileAssemblerBlock.FACING) ? ((Direction)state.getValue((Property)AutomobileAssemblerBlock.FACING)).toYRot() - 90.0f : 0.0f;
    }

    @Override
    public int getWheelCount() {
        return this.wheelCount;
    }

    @Override
    public float getRearAttachmentYaw(float tickDelta) {
        return 0.0f;
    }

    @Override
    public float getWheelAngle(float tickDelta) {
        return this.powered() ? ((float)this.getTime() + tickDelta) * 36.0f : 0.0f;
    }

    @Override
    public float getSteering(float tickDelta) {
        return 0.0f;
    }

    @Override
    public float getSuspensionBounce(float tickDelta) {
        return 0.0f;
    }

    @Override
    public boolean engineRunning() {
        return this.powered();
    }

    @Override
    public int getBoostTimer() {
        return this.powered() ? 1 : 0;
    }

    @Override
    public int getTurboCharge() {
        return 0;
    }

    @Override
    public long getTime() {
        return this.level.getGameTime();
    }

    @Override
    public boolean automobileOnGround() {
        return false;
    }

    @Override
    public boolean debris() {
        return false;
    }

    @Override
    public Vector3f debrisColor() {
        return null;
    }
}

